﻿using System;
using System.Linq;
using VA.TMP.DataModel;
using VA.TMP.Integration.VIMT.VirtualMeetingRoom.StateObject;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.VirtualMeetingRoom.PipelineSteps.Create
{
    /// <summary>
    /// Get Service Appointment step.
    /// </summary>
    public class GetServiceAppointmentStep : FilterBase<VirtualMeetingRoomCreateStateObject>
    {
        /// <summary>
        /// Execute the step.
        /// </summary>
        /// <param name="state">State object.</param>
        public override void Execute(VirtualMeetingRoomCreateStateObject state)
        {
            using (var context = new Xrm(state.OrganizationServiceProxy))
            {
                state.ServiceAppointment = context.ServiceAppointmentSet.FirstOrDefault(x => x.Id == state.AppointmentId); 
                if (state.ServiceAppointment == null) throw new Exception(string.Format("Unable to retrieve Service Appointment - {0}", state.AppointmentId));

                if (state.ServiceAppointment.ScheduledStart == null) throw new Exception(string.Format("Service Appointment Start Date is null - {0}", state.AppointmentId));
                if (state.ServiceAppointment.ScheduledEnd == null) throw new Exception(string.Format("Service Appointment End Date is null - {0}", state.AppointmentId));

                state.AppointmentStartDate = (DateTime) state.ServiceAppointment.ScheduledStart;
                state.AppointmentEndDate = (DateTime) state.ServiceAppointment.ScheduledEnd;
            }
        }
    }
}